<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");

date_default_timezone_set("America/Caracas");
session_start();
require('config/conexion.php');


if (!isset($_SESSION['usuario'])) {
    header('Location: index.php');
    exit();
}

try {
    // Preparar la consulta SQL para obtener los datos
    $sql = "SELECT valor FROM config WHERE id = 3";
    $stmt = $conn->prepare($sql);
    $stmt->execute();

    // Obtener los resultados
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $valor = $row['valor'];
        list($ip, $port, $user, $password) = explode('^', $valor);

        echo json_encode(['success' => true, 'ip' => $ip, 'port' => $port, 'user' => $user, 'password' => $password]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No se encontraron datos']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Error en la consulta: ' . $e->getMessage()]);
}

$conn = null;
?>
