<?php
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if ($id > 0) {
        // Obtener el valor actual del campo 'usada'
        $sql_select = "SELECT usada FROM accounts WHERE id = ?";
        $stmt_select = $conexion->prepare($sql_select);
        $stmt_select->bind_param("i", $id);
        $stmt_select->execute();
        $result = $stmt_select->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $usada_actual = $row['usada'];

            // Determinar el nuevo valor a establecer
            $nuevo_valor = ($usada_actual == '1') ? null : "1";


            // Actualizar el valor
            $sql_update = "UPDATE accounts SET usada = ? WHERE id = ?";
            $stmt_update = $conexion->prepare($sql_update);
            $stmt_update->bind_param("si", $nuevo_valor, $id);

            if ($stmt_update->execute()) {
                echo json_encode(["success" => true, "nuevo_valor" => $nuevo_valor]);
            } else {
                echo json_encode(["success" => false, "message" => "Error al actualizar la cuenta."]);
            }

            $stmt_update->close();
        } else {
            echo json_encode(["success" => false, "message" => "Cuenta no encontrada."]);
        }

        $stmt_select->close();
    } else {
        echo json_encode(["success" => false, "message" => "ID inválido."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Método no permitido."]);
}

$conexion->close();
?>
